<?php
// Ścieżka: public_html/trasy/sync.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$configPath = __DIR__ . '/../../private/config.php';
if (!file_exists($configPath)) { http_response_code(500); exit; }
$config = require $configPath;

try {
    $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
    $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    // Pobieramy TYLKO numery zamówień, które są w tabeli
    $stmt = $pdo->query("SELECT numer_zamowienia FROM potwierdzenia_dostaw");
    $ids = $stmt->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode($ids); // Zwracamy listę np. ["ZAM1", "ZAM2"]

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([]);
}
?>