<?php
// Ścieżka: public_html/trasy/api.php

// Nagłówki wymagane do komunikacji z aplikacją JS
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Obsługa tzw. pre-flight request (dla niektórych przeglądarek mobilnych)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// 1. Ładowanie konfiguracji
$configPath = __DIR__ . '/../../private/config.php';
if (!file_exists($configPath)) {
    http_response_code(500);
    echo json_encode(['error' => 'Błąd konfiguracji serwera']);
    exit;
}
$config = require $configPath;

// 2. Odbieranie danych JSON (Login i Hasło)
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$user = isset($input['user']) ? strtoupper(trim($input['user'])) : '';
$pass = isset($input['pass']) ? trim($input['pass']) : '';

// 3. Weryfikacja użytkownika
if (empty($user) || empty($pass) || !isset($config['kierowcy'][$user]) || $config['kierowcy'][$user] !== $pass) {
    http_response_code(401);
    echo json_encode(['error' => 'Błędny login lub hasło']);
    exit;
}

// 4. Funkcja do odszyfrowywania danych z bazy
function odszyfruj($tekst, $key) {
    if (empty($tekst)) return '';
    
    // Sprawdzamy czy tekst w ogóle wygląda na base64 (zabezpieczenie przed błędami)
    $data = base64_decode($tekst, true);
    if ($data === false) return $tekst; // Jeśli to nie szyfr, zwróć jak jest

    $ivLength = openssl_cipher_iv_length("AES-256-CBC");
    // Zabezpieczenie: jeśli dane są za krótkie, to nie jest poprawny szyfr
    if (strlen($data) < $ivLength) return $tekst;

    $iv = substr($data, 0, $ivLength);
    $encrypted = substr($data, $ivLength);
    
    $decrypted = openssl_decrypt($encrypted, "AES-256-CBC", $key, 0, $iv);
    return $decrypted !== false ? $decrypted : $tekst;
}

try {
    // 5. Połączenie z bazą
    $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
    $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    // 6. Zapytanie SQL (tylko jedna tabela pro-trasy)
    $sql = "SELECT * FROM `pro-trasy` WHERE 1=1";
    $params = [];

    // Jeśli to nie ADMIN, filtrujemy po końcówce nazwy trasy (np. '% DW')
    if ($user !== 'ADMIN') {
        $sql .= " AND nazwa_trasy LIKE :suffix";
        $params['suffix'] = "% " . $user;
    }

    // Sortowanie: Najpierw data, potem godzina
    $sql .= " ORDER BY data_dostawy ASC, godzina_dostawy ASC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $trasy = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 7. Przetwarzanie wyników (odszyfrowanie wrażliwych pól)
    $wynik = [];
    foreach ($trasy as $row) {
        $row['imie_nazwisko'] = odszyfruj($row['imie_nazwisko'], $config['encryption_key']);
        $row['ulica']         = odszyfruj($row['ulica'], $config['encryption_key']);
        $row['telefon']       = odszyfruj($row['telefon'], $config['encryption_key']);
        $row['email']         = odszyfruj($row['email'], $config['encryption_key']);
        
        $wynik[] = $row;
    }

    // 8. Wysyłamy odpowiedź JSON
    echo json_encode($wynik);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Błąd bazy danych: ' . $e->getMessage()]);
}
?>