<?php
// Ścieżka: public_html/trasy/admin.php
session_start();

// --- KONFIGURACJA LOGOWANIA ---
$adminUser = 'admin';           // Login do panelu
$adminPass = 'HASLO_DO_PANELU'; // <--- ZMIEŃ TO HASŁO!!!

// --- 1. OBSŁUGA LOGOWANIA ---
if (isset($_POST['login']) && isset($_POST['pass'])) {
    if ($_POST['login'] === $adminUser && $_POST['pass'] === $adminPass) {
        $_SESSION['admin_logged'] = true;
        header("Location: admin.php"); // Przeładowanie, żeby ukryć POST
        exit;
    } else {
        $error = "Błędne hasło!";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// Jeśli nie zalogowany, pokaż formularz
if (!isset($_SESSION['admin_logged'])) {
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logowanie Administratora</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>body { background: #f0f2f5; display: flex; align-items: center; justify-content: center; height: 100vh; }</style>
</head>
<body>
    <div class="card p-4 shadow" style="width: 100%; max-width: 400px;">
        <h3 class="text-center mb-4">🔐 Panel Admina</h3>
        <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
        <form method="post">
            <div class="mb-3"><label>Login</label><input type="text" name="login" class="form-control" required></div>
            <div class="mb-3"><label>Hasło</label><input type="password" name="pass" class="form-control" required></div>
            <button type="submit" class="btn btn-primary w-100">Zaloguj</button>
        </form>
    </div>
</body>
</html>
<?php
    exit; // Koniec skryptu dla niezalogowanych
}

// --- 2. CZĘŚĆ WŁAŚCIWA PANELU (DLA ZALOGOWANYCH) ---

// Ładowanie konfiguracji
$configPath = __DIR__ . '/../../private/config.php';
if (!file_exists($configPath)) die("Błąd: Brak pliku config.php");
$config = require $configPath;

// Funkcja odszyfrowująca podpis
function odszyfrujPodpis($tekst, $key) {
    if (empty($tekst)) return '';
    $dane = base64_decode($tekst);
    if ($dane === false) return '';
    
    $ivLength = openssl_cipher_iv_length("AES-256-CBC");
    if (strlen($dane) < $ivLength) return '';

    $iv = substr($dane, 0, $ivLength);
    $encrypted = substr($dane, $ivLength);
    return openssl_decrypt($encrypted, "AES-256-CBC", $key, 0, $iv);
}

// Połączenie z bazą
try {
    $pdo = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", $config['db_user'], $config['db_pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Pobieramy ostatnie 100 dostaw
    $sql = "SELECT * FROM potwierdzenia_dostaw ORDER BY data_dostawy DESC LIMIT 100";
    $stmt = $pdo->query($sql);
    $dostawy = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (PDOException $e) {
    die("Błąd bazy danych: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Potwierdzenia Dostaw</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .img-thumb { width: 80px; height: 80px; object-fit: cover; border-radius: 6px; border: 1px solid #dee2e6; cursor: pointer; transition: transform 0.2s; }
        .img-thumb:hover { transform: scale(1.1); }
        .signature-img { width: 200px; border: 1px dashed #ccc; padding: 5px; background: #fff; border-radius: 5px; }
        .table-td-middle { vertical-align: middle; }
    </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-dark bg-dark mb-4">
  <div class="container">
    <span class="navbar-brand mb-0 h1">📋 Panel Dostaw</span>
    <a href="admin.php?logout=1" class="btn btn-outline-light btn-sm">Wyloguj</a>
  </div>
</nav>

<div class="container">
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h5 class="mb-0">Ostatnie zrealizowane dostawy</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover mb-0 align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Zamówienie</th>
                        <th>Kierowca</th>
                        <th>Data</th>
                        <th>Komentarz</th>
                        <th>Zdjęcia</th>
                        <th>Podpis</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($dostawy as $row): ?>
                    <?php 
                        // Odszyfrowanie podpisu
                        $srcPodpis = odszyfrujPodpis($row['podpis_base64'], $config['encryption_key']);
                        // Dekodowanie zdjęć
                        $zdjecia = json_decode($row['sciezki_zdjec'], true) ?? [];
                        $dataFormat = date('d.m.Y H:i', strtotime($row['data_dostawy']));
                    ?>
                    <tr>
                        <td>
                            <strong class="text-primary">#<?php echo htmlspecialchars($row['numer_zamowienia']); ?></strong>
                        </td>
                        <td>
                            <span class="badge bg-secondary"><?php echo htmlspecialchars($row['kierowca']); ?></span>
                        </td>
                        <td><?php echo $dataFormat; ?></td>
                        <td>
                            <?php if(!empty($row['komentarz_kierowcy'])): ?>
                                <div class="alert alert-warning py-1 px-2 mb-0 small">
                                    <i class="fas fa-comment"></i> <?php echo htmlspecialchars($row['komentarz_kierowcy']); ?>
                                </div>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex gap-1 flex-wrap">
                                <?php if(empty($zdjecia)): ?>
                                    <span class="text-muted small">Brak zdjęć</span>
                                <?php else: ?>
                                    <?php foreach($zdjecia as $foto): ?>
                                        <a href="view_image.php?file=<?php echo urlencode($foto); ?>" target="_blank">
                                            <img src="view_image.php?file=<?php echo urlencode($foto); ?>" class="img-thumb">
                                        </a>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <?php if ($srcPodpis): ?>
                                <img src="<?php echo $srcPodpis; ?>" class="signature-img" alt="Podpis">
                            <?php else: ?>
                                <span class="badge bg-danger">Błąd podpisu</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                
                <?php if(count($dostawy) == 0): ?>
                    <tr><td colspan="6" class="text-center py-4 text-muted">Brak danych w bazie</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</body>
</html>